﻿var criterionExpressionEditor = {
    context: $(".v-criterionExpressionEditor"),
    variablesOnly: $("#VariablesOnly").val() == "True",
    initialize: function () {
        $(".v-conditionsTable tbody tr", this.context).each(function () {
            var row = $(this);
            var autoComplete = criterionExpressionEditor.setVariablesAutoComplete(row);
            var selectedItem = autoComplete.a4autocomplete("getValue");

            if (selectedItem.HasChoiceList) {
                criterionExpressionEditor.setValuesAutoComplete(row, selectedItem.Value, selectedItem.IsDiscrete);
            }
            else {
                //$(".h-conditionValueAutocomplete", row).val($(".v-conditionValue", row).val());

                $(".h-conditionValueAutocomplete", row).change(function () {
                    $(".v-conditionValue", row).val($(this).val());
                });
            }
        });
    },
    bindEvents: function () {
        this.context.on("click", ".h-addConditionRow", function () {
            var table = $(".v-conditionsTable", criterionExpressionEditor.context);
            var row = $("tfoot .v-conditionRow", table).clone();
            var index = $("tbody tr", table).length;
            var modelName = table.attr("data-name");

            $("tbody", table).append(row);

            criterionExpressionEditor.toggleItemsVisibility();
            criterionExpressionEditor.setVariablesAutoComplete(row);
            criterionExpressionEditor.setConditionInputs(modelName, index, row);
        });

        $(".v-conditionsTable", this.context).on("click", ".h-deleteRow", function () {
            $(this).closest("tr").remove();

            criterionExpressionEditor.reindexConditionsTable();
            criterionExpressionEditor.toggleItemsVisibility();
        });

        this.context.on("change", ".h-conditionType", function () {
            $(".v-customConditionPanel", criterionExpressionEditor.context).toggle($(this).val() == "Custom");
        });
    },
    reindexConditionsTable: function () {
        var table = $(".v-conditionsTable", this.context);
        var modelName = table.attr("data-name");

        $("tbody tr", table).each(function (index) {
            criterionExpressionEditor.setConditionInputs(modelName, index, $(this));
        });
    },
    setConditionInputs: function (modelName, index, row) {
        this.setConditionInputName(modelName, index, $(".h-conditionVariable", row));
        this.setConditionInputName(modelName, index, $(".v-conditionOperator", row));
        this.setConditionInputName(modelName, index, $(".v-conditionValue", row));
        this.setConditionInputName(modelName, index, $(".v-conditionIndex", row));

        $(".v-conditionIndex", row).val(index + 1);
        $(".v-index", row).text(index + 1);
    },
    setConditionInputName: function (modelName, index, input) {
        input.attr("name", modelName + "[" + index + "]." + input.attr("data-name"));
    },
    setVariablesAutoComplete: function (row) {
        return $(".h-conditionVariable", row).a4autocomplete({
            ajaxAction: a4.getProjectAction("GetQuestionsForAutoComplete", "Shared"),
            ajaxParams: { projectId: $("#ProjectId").val(), mustHaveChoices : true },
            select: function (event, data) {
                criterionExpressionEditor.clearValuesAutoComplete(row);

                if (data.item && data.item.HasChoiceList) {
                    criterionExpressionEditor.setValuesAutoComplete(row, data.item.Value, data.item.IsDiscrete);
                }
                else {
                    $(".h-conditionValueAutocomplete", row).on("change", function () {
                        $(".v-conditionValue", row).val($(this).val());
                    });
                }
            }
        });
    },
    clearValuesAutoComplete: function (row) {
        if ($(".h-conditionValueAutocomplete", row).hasClass("autocomplete")) {
            $(".h-conditionValueAutocomplete", row).a4autocomplete("destroy");
        }
        else {
            $(".h-conditionValueAutocomplete", row).val("");
            $(".h-conditionValueAutocomplete", row).off("change");
        }
    },
    setValuesAutoComplete: function (row, variable, isDiscreteVariable) {
        $(".h-conditionValueAutocomplete", row).a4autocomplete({
            ajaxAction: a4.getProjectAction("GetVariableChoices", "Shared"),
            ajaxParams: { variableName: variable },            
            validateSelection: isDiscreteVariable,
            altValueField: $(".v-conditionValue", row)
        });
    },
    toggleItemsVisibility: function () {
        var table = $(".v-conditionsTable", this.context);
        var rowsCount = $("tbody tr", table).length;

        $(".v-conditionTypePanel", this.context).toggle(rowsCount > 1);
        $(".v-customConditionPanel", this.context).toggle(rowsCount > 1 && $(".h-conditionType", this.context).val() == "Custom");
        table.toggle(rowsCount > 0);
    },
    getExpression: function () {
        var conditionType = $(".h-conditionType", this.context).val();
        var customCondition = $(".v-customCondition", this.context).val();
        var conditions = $(".v-conditionsTable tbody .v-conditionRow", this.context).map(function () {
            return {
                Index: parseInt($(this).find(".v-conditionIndex").val()),
                VariableName: $(this).find(".h-conditionVariable").val(),
                Operator: $(this).find(".v-conditionOperator").val(),
                Value: $(this).find(".v-conditionValue").val()
            }
        }).get();

        return {
            ConditionType: conditionType,
            CustomCondition: customCondition,
            Conditions: conditions
        };
    },
    reinitialize: function () {
        var table = $(".v-conditionsTable", this.context);
        $("tbody tr", table).remove();
        $(".v-conditionTypePanel", this.context).toggle(false);
        table.toggle(false);
    }
}

$(document).ready(function () {
    if (criterionExpressionEditor.context.length > 0) {
        criterionExpressionEditor.initialize();
        criterionExpressionEditor.bindEvents();
    }
});